% -----------------
% Problema de canal
% -----------------
% Queremos diseñar un canal para transporte de agua, revestido de hormigón con sección trapezoidal, con inclinación de 60º
% El área de nuestra sección debe ser 6 m2 para poder llevar el caudal calculado. Si el metro lineal de hormigón colocado en obra cuesta 30€/m
% ¿Cuál es la sección óptima para obtener el mejor precio? 
%
% --- DATOS ---
% Perimetro sección: 2*l+b
% Sección 6 m2
% Area: A=(b+l*cos(60))*l*sin(60)
% b = (l^2*sin(60)*cos(60)-A) / (l*sin(60))
% 
% --- SOLUCION ---
% Damos valores a l, obtenemos b, calculamos precio
A=6;
l=0.1:0.1:5;
ang=50
b = (A - l.^2.*sind(ang).*cosd(ang)) ./ (l.*sind(ang));
peri=2*l+b;
precio=peri*30;
%b',l', peri', precio'

for j=1:length(l)
   fprintf('%s %1.3f \t %s %1.3f \t %s %1.3f \t %s %1.2f \n','l:', l(j),'b:', b(j), 'peri:', peri(j),'euros:', precio(j))
end

